/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemLoreFragment;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeUnlocker
extends class_1792
implements MediaHolderItem {
    public static final String DISPLAY_MEDIA = "media";
    public static final String DISPLAY_PATTERNS = "patterns";
    public static final String TAG_EXTRACTIONS = "extractions";
    public static final String TAG_INSERTIONS = "insertions";

    public static boolean isDebug(class_1799 stack) {
        return ItemCreativeUnlocker.isDebug(stack, null);
    }

    public static boolean isDebug(class_1799 stack, String flag) {
        if (!stack.method_31574((class_1792)HexItems.CREATIVE_UNLOCKER) || !stack.method_7938()) {
            return false;
        }
        List<String> keywords = Arrays.asList(stack.method_7964().getString().toLowerCase(Locale.ROOT).split(" "));
        if (!keywords.contains("debug")) {
            return false;
        }
        return flag == null || keywords.contains(flag);
    }

    public static class_2561 infiniteMedia(class_1937 level) {
        String prefix = "item.hexcasting.creative_unlocker.";
        String emphasis = class_2477.method_10517().method_48307(prefix + "for_emphasis");
        class_5250 emphasized = class_2561.method_43473();
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.method_10852((class_2561)ItemCreativeUnlocker.rainbow(class_2561.method_43470((String)("" + emphasis.charAt(i))), i, level));
        }
        return emphasized;
    }

    public ItemCreativeUnlocker(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public long getMedia(class_1799 stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxMedia(class_1799 stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public void setMedia(class_1799 stack, long media) {
    }

    @Override
    public boolean canProvideMedia(class_1799 stack) {
        return true;
    }

    @Override
    public boolean canRecharge(class_1799 stack) {
        return true;
    }

    public static void addToIntArray(class_1799 stack, String tag, int n) {
        int[] arr = NBTHelper.getIntArray(stack, tag);
        if (arr == null) {
            arr = new int[]{};
        }
        int[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[newArr.length - 1] = n;
        NBTHelper.putIntArray(stack, tag, newArr);
    }

    public static void addToLongArray(class_1799 stack, String tag, long n) {
        long[] arr = NBTHelper.getLongArray(stack, tag);
        if (arr == null) {
            arr = new long[]{};
        }
        long[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[newArr.length - 1] = n;
        NBTHelper.putLongArray(stack, tag, newArr);
    }

    @Override
    public long withdrawMedia(class_1799 stack, long cost, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToLongArray(stack, TAG_EXTRACTIONS, cost);
        }
        return cost < 0L ? this.getMedia(stack) : cost;
    }

    @Override
    public long insertMedia(class_1799 stack, long amount, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToLongArray(stack, TAG_INSERTIONS, amount);
        }
        return amount < 0L ? this.getMaxMedia(stack) : amount;
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || ItemCreativeUnlocker.isDebug(stack);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        if (ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA) && !level.field_9236) {
            this.debugDisplay(stack, TAG_EXTRACTIONS, "withdrawn", "all_media", entity);
            this.debugDisplay(stack, TAG_INSERTIONS, "inserted", "infinite_media", entity);
        }
    }

    private void debugDisplay(class_1799 stack, String tag, String langKey, String allKey, class_1297 entity) {
        long[] arr = NBTHelper.getLongArray(stack, tag);
        if (arr != null) {
            NBTHelper.remove(stack, tag);
            for (long i : arr) {
                if (i < 0L) {
                    entity.method_43496((class_2561)class_2561.method_43469((String)("hexcasting.debug.media_" + langKey), (Object[])new Object[]{stack.method_7954(), class_2561.method_43471((String)("hexcasting.debug." + allKey)).method_27692(class_124.field_1080)}).method_27692(class_124.field_1076));
                    continue;
                }
                entity.method_43496((class_2561)class_2561.method_43469((String)("hexcasting.debug.media_" + langKey + ".with_dust"), (Object[])new Object[]{stack.method_7954(), class_2561.method_43470((String)("" + i)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.format("%.2f", (double)i * 1.0 / 10000.0)).method_27692(class_124.field_1068)}).method_27692(class_124.field_1076));
            }
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_2586 be = context.method_8045().method_8321(context.method_8037());
        if (be instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)be;
            impetus.setInfiniteMedia();
            context.method_8045().method_8396(null, context.method_8037(), HexSounds.SPELL_CIRCLE_FIND_BLOCK, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)context.method_8045().method_8608());
        }
        return class_1269.field_5811;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 consumer) {
        if (level instanceof class_3218) {
            class_3218 slevel = (class_3218)level;
            if (consumer instanceof class_3222) {
                class_3222 player = (class_3222)consumer;
                ArrayList<class_2960> names = new ArrayList<class_2960>(ItemLoreFragment.NAMES);
                names.add(0, HexAPI.modLoc("root"));
                for (class_2960 name : names) {
                    class_161 rootAdv = slevel.method_8503().method_3851().method_12896(name);
                    if (rootAdv == null) continue;
                    ArrayList<class_161> children = new ArrayList<class_161>();
                    children.add(rootAdv);
                    ItemCreativeUnlocker.addChildren(rootAdv, children);
                    class_2985 adman = player.method_14236();
                    for (class_161 kid : children) {
                        class_167 progress = adman.method_12882(kid);
                        if (progress.method_740()) continue;
                        for (String crit : progress.method_731()) {
                            adman.method_12878(kid, crit);
                        }
                    }
                }
            }
        }
        class_1799 copy = stack.method_7972();
        super.method_7861(stack, level, consumer);
        return copy;
    }

    private static class_5250 rainbow(class_5250 component, int shift, class_1937 level) {
        if (level == null) {
            return component.method_27692(class_124.field_1068);
        }
        return component.method_27694(s -> s.method_27703(class_5251.method_27717((int)class_3532.method_15369((float)((float)((level.method_8510() + (long)shift) * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        class_2561 emphasized = ItemCreativeUnlocker.infiniteMedia(level);
        class_5250 modName = class_2561.method_43471((String)"item.hexcasting.creative_unlocker.mod_name").method_27694(s -> s.method_27703(ItemMediaHolder.HEX_COLOR));
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{emphasized}).method_27692(class_124.field_1080));
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.hexcasting.creative_unlocker.tooltip", (Object[])new Object[]{modName}).method_27692(class_124.field_1080));
    }

    private static void addChildren(class_161 root, List<class_161> out) {
        for (class_161 kiddo : root.method_681()) {
            out.add(kiddo);
            ItemCreativeUnlocker.addChildren(kiddo, out);
        }
    }

    static {
        DiscoveryHandlers.addDebugItemDiscoverer((player, type) -> {
            for (class_1799 item : player.method_31548().field_7547) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (class_1799 item : player.method_31548().field_7548) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (class_1799 item : player.method_31548().field_7544) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            return class_1799.field_8037;
        });
    }
}

